#ifndef TYPEDEF_H_INCLUDED
#define TYPEDEF_H_INCLUDED

#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>

// Enumeration des Types d'lements de GUI
enum gui_type {
IMAGE,  // Simple image
TEXTE,  // Simple texte
BOUTON, // Bouton avec une action lors d'un clic
SWITCH, // Bouton ON/OFF
SAISIE  // Entre utilisateur
};

// Action des venements du GUI
enum gui_flag {
//Fenetre
AUCUN,              // Ne dclenche rien (mais peut modifier une donne de manire transparente)
MESSAGE,
// Menu
AIDE,
CREER,
RESEAU,
OPTIONS,
QUITTER,
//Actions
APPRENDRE,
CHARGER,
TRACER,
SAUVEGARDER,
DETRUIRE,
//Menu Crer
FORME_SPIRALE,
FORME_PERSO,
NOUVEAU_NOM,
COUCHES,
NOUVEAU_EPSILON,
NOUVEAU_SEUIL,
COORD,
SWITCH_FORME,
SPIRALE_POINTS,
SPIRALE_OFFSET,
SPIRALE_PHASE,
DESSINER,
NOUVEAU_COULEUR_A,
NOUVEAU_COULEUR_B,
NOUVEAU_APPRENDRE,
// Apprentissage
PROGRESSION,
// Menu Rseau
CADRE_RESULTAT,      // Cadre dans lequel on affiche le rsultat sur une surface du rseau de neurones
STATISTIQUES,
EPSILON,
SEUIL,
COULEUR_A,
COULEUR_B,
NOM,
// Menu Dessin
CADRE_DESSIN,
SWITCH_DESSIN,
FORME_A,
FORME_B,
ANNULER,
EFFACER
};

// Action des venements du GUI
enum gui_groupe {
FENETRE,         // Pas de groupe particulier
PRESENTATION,
MENU,            // Menu Principal
MENU_CREER,    // Menu de nouveau rseau
MENU_RESEAU,   // Menu de l'apprentissage
MENU_DESSIN,
DEROUL_FORME,
DEROUL_DESSIN,
CONFIG_SPIRALE,
CONFIG_PERSO
};

// Etat des elements
enum gui_etat {
INACTIF,    // Element inactif
SURVOL,     // Element survol (Highlihted)
ACTIF       // Element actif (cliqu, actionn,...)
};

// Flag d'indication de la manire de librer les donnes d'un element
enum gui_free {
FREE_RIEN=0,    // Ne rien liberer (car pointeurs obselete)
FREE_IMAGE=1,   // Librer la surface de l'image
FREE_VALEUR=2   // Librer la chaine de caractre de la valeur
};


// Flag d'indication du style (combinable)
enum gui_style {
STYLE_GROS=1,    // Met l'element en texte gros
STYLE_NOIR=2,   // Met l'element en texte noir
STYLE_ORANGE=4,   // Met l'element en texte color orange
STYLE_CENTRE=8
};

typedef struct s_options{
    long dessin_ms;
    long apprentissage_ms;
    long pts_boucle;
    double interval_poids;
    long apercu_resolution;
} t_options;

typedef struct s_point{
    double x;
    double y;
    long forme;
} t_point;

// Structure d'un lement du GUI - Graphical User Interface
typedef struct s_gui_element {
    /// Apparence de l'element
    enum gui_type type; // Type de l'element (BOUTON, IMAGE, SWITCH, etc...)
    SDL_Surface *image; // Surface de l'image de l'element
    char *valeur; // Texte ou Valeur de l'element
    char *info; // Texte Descriptif de l'element
    SDL_Rect position; // Position de l'element
    SDL_Rect crop; // Coordonnes de rognage
    long etat; //0 -> Inactif, 1-> MOUSE_OVER, 2 - ACTIF
    long visible; // Boolen qui indique sa visibilit
    enum gui_style style; // Style le l'element

    ///Fonction de l'element
    enum gui_flag flag; // Action de l'element
    enum gui_groupe groupe; // Groupe d'elements auquel appartient l'element
    /// Traitement de l'element
    enum gui_free free; // Determine comment l'element doit tre supprim
//  long actualiser; // Determine si l'element a t modifi, et s'il doit tre re-blitt
} t_gui_element;

// Structure Unique de l'interface
typedef struct s_interface {
    /// Donnes d'affichage SDL
    SDL_Surface* fenetre; // Surface contenant la fenetre
    SDL_Surface **texture; // Images des boutons, etc.
    long nbr_textures; // Nombres d'images/textures
    TTF_Font* font; // Police de Caractre de l'interface
    TTF_Font* font_gros; // Police de Caractre en gros de l'interface

    /// Donnes du GUI
    long gui_taille; // Nombre d'elements du GUI
    t_gui_element* gui; // Liste des elements du GUI
    t_gui_element* gui_actif; // Pointeur sur l'element du GUI Actif/Courant

    /// Donnes de la saisie utilisatuer
    long continuer;
    SDL_Rect pointeur;// Position de la souris
    long clic; // Boolen de l'tat du clic (gauche)
    SDLKey touche; // La touche actuellement enfonce
    long mousefocus; // Boolen qui indique si la souris est dans la fenetre
    long appfocus;// Utilis pour le clic, et le dessin de la map, et le focus de la fenetre

    /// Donnes de l'diteur de maps
    char accent; //Retient si un accent (circonflxe, trma ou tilde) est entr
    t_options options;
    long charge;// Indique si un rseau est charg

    long nbr_points;// nombre de points du dessin
    t_point *points;// dessin  main leve
} t_interface;

typedef enum enum_mode  // Dfinit le type des modes de gnration des points exemples
{
    PERSO,              // Points personaliss / Dessin
    SPIRALES            // Spirales
} t_mode;

typedef enum enum_coord // Dfinit le type de coordonnes
{
    CART,               // Coordonnes cartsiennes
    POL                 // Coordonnes polaires
} t_coord;

typedef struct s_reseau
{
    long nbr_couches;   // Nombre de couches (entre, caches et sortie)
    long *nbr_neurones; // nbr_neurones[i] -> Nombre de neurones pour la couche i
    double ***poids;    // poids[i][j][k] -> Poids de l'entre k pour le neurone j de la couche i
    double **resultat;  // resultat[i][j] -> Sortie du neurone j de la couche i
    double **delta;     // delta[i][j] -> Facteur de correction d'erreur pour le neurone j de la couche i

    SDL_Color *forme;   // Couleurs des formes
    t_mode mode;        // Mode de gnration des points exemples
    long offset;        // Nombre de points ignors pour la gnration des 2 spirales (sans compter l'origine)
    double phase;       // Phase en radian des spirales
    long nbr_pts;       // Nombre de points de l'ensemble d'exemples
    double **pts;       // Coordonnes de ces points
    double **att;       // Valeurs attendues en sorties du rseau pour ces points

    double epsilon;     // Facteur d'apprentissage
    double seuil;       // Seuil de correction (vite le sur-apprentissage)
    t_coord coord;      // Coordonnes utilises pour cet ensemble d'exemple
    long *temps;        // Temps d'apprentissage en ms
} t_reseau;

#endif // TYPEDEF_H_INCLUDED
