#ifndef INTERFACE_H_INCLUDED
#define INTERFACE_H_INCLUDED

#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>
#include "typedef.h"
#include "couche.h"

#define SAISIE_MAX 255
#define TITRE "Meningix"

#define BITSPERPIXEL 32
#define POLICE_TEXTE "redensek.ttf"
#define POLICE_TAILLE_NORMALE 18
#define POLICE_TAILLE_GROS 32

#if SDL_BYTEORDER == SDL_BIG_ENDIAN
    #define RMASK  0xff000000
    #define GMASK  0x00ff0000
    #define BMASK  0x0000ff00
    #define AMASK  0x000000ff
#else
    #define RMASK  0x000000ff
    #define GMASK  0x0000ff00
    #define BMASK  0x00ff0000
    #define AMASK  0xff000000
#endif

#define RESSOURCES_DIR "ressources/"

// Fonctions d'initialisation / libration
void charger_config(t_interface *interface); // Charge les donnes enregistre depuis le fichier de config
void initialiser_affichage(SDL_Surface** fenetre,long largeur,long hauteur); // Initialise la SDL
void initialiser_interface(t_interface* interface); // Initialise l'interface et les elements du GUI
void liberer_interface(t_interface* interface); // Supprime les donnes de l'interface
void liberer_affichage(SDL_Surface* fenetre); // Libre la fenetre, et quitte les librairies initialises

// Fonctions d'affichage / Rafraichissement
void afficher_interface(t_interface* interface,t_reseau *res); // Affiche l'interface
void afficher_message(t_interface *interface, char *txt, long error); // Affiche un message dans la fenetre de chat

// Fonctions de gestion des venements GUI
long obtenir_element(t_interface *interface,enum gui_flag flag);// Rcupre le dernier element portant le flag prcis
void afficher_groupe(t_interface *interface, enum gui_groupe groupe, long visible, long masquer);// Affiche le groupe d'elements prcis, et masque les autres
void actualiser_gui(long element,t_interface* interface,t_reseau *res); // Actualise les elements et les donnes avant affichage
void effectuer_gui(enum gui_flag flag,t_interface* interface,t_reseau *res); // Effectuer l'action d'un flag

// Fonctions Diverses
long comparer_commande(char *cmd, char *str); // Verifie si la chaine de caractre correspond  la commande passe
long configurer_apprentissage(t_interface *aff,t_reseau *res);
long interpreter_couches(t_reseau *res, char *str,long charge,double interval_poids);
long charger(t_interface *aff,t_reseau *res, char *nom_reseau);
long ajouter_point(t_interface *interface);
void supprimer_point(t_interface *interface);
void effacer_dessin(t_interface *interface);
void afficher_dessin(t_interface *interface);
long convertir_dessin(t_reseau *res,t_interface *interface,long coord);
void afficher_statistiques(t_reseau *res, char *texte);

#endif // INTERFACE_H_INCLUDED
