#include <math.h>
#include "interface.h"

// Initialise la SDL
void initialiser_affichage(SDL_Surface** fenetre,long largeur,long hauteur)
{
    SDL_Surface *stemp;
    char str[SAISIE_MAX];

    // On initialise la SDL
    if ( SDL_Init( SDL_INIT_VIDEO ) < 0 ) // Mode Video seulement pour le moment
    {
        printf( "Impossible d'initialiser la SDL: %s\n", SDL_GetError() );
        exit(EXIT_FAILURE);
    }

    // On initialise SDL_ttf
    if(TTF_Init() == -1)
    {
        printf("Erreur d'initialisation de TTF_Init : %s\n", TTF_GetError());
        exit(EXIT_FAILURE);
    }

    putenv("SDL_VIDEO_WINDOW_POS=center"); //pour centrer la fentre
    sprintf(str,"%s%s",RESSOURCES_DIR,"meningix.png");
    stemp = IMG_Load(str);
    SDL_WM_SetIcon(stemp,NULL);
    free(stemp);

    // On cre la fenetre
    *fenetre = SDL_SetVideoMode(largeur,hauteur, BITSPERPIXEL,SDL_HWSURFACE);
    if (!*fenetre )
    {
        printf("Impossible d'afficher en %ldx%ld: %s\n",largeur,hauteur, SDL_GetError());
        exit(EXIT_FAILURE);
    }

    SDL_WM_SetCaption(TITRE, NULL); //On donne un titre  la fentre
    SDL_EnableUNICODE(1); // On active la saisie Unicode
    SDL_EnableKeyRepeat(250, 40); // On active la rptition des touches dlai 250ms, rptition 100ms

}

// Initialise l'interface et les elements du GUI
void initialiser_interface(t_interface* interface) // A OPTIMISER (Chargement (spar) - ALPHA, cache texte static)
{
    long n,t,temp; // compteur
    SDL_Surface *stemp;
    char str[255];
    str[0]=0;

    /// Variables de l'interface
    interface->continuer = 1; // Pseudo-Boolen qui indique si on continue la boucle principale
    interface->clic=0; // Etat du clic (gauche)
    interface->touche=0; // Touche actuellement enfonce
    interface->mousefocus=1; // Indique si le pointeur est dans la fenetre
    interface->appfocus=1;// Indique si la fenetre a le focus (clavier)
    interface->charge=0;//Pas de rseau charg
    interface->accent=0;// Pas d'accent retenu en memoire

    interface->nbr_points=0;// Pas de points dessin
    interface->points=NULL;

    sprintf(str,"%s%s",RESSOURCES_DIR,POLICE_TEXTE);
    interface->font = TTF_OpenFont(str, POLICE_TAILLE_NORMALE); // On charge la Police de caractre
    interface->font_gros = TTF_OpenFont(str, POLICE_TAILLE_GROS); // On charge la Police de caractre en Gros

    t = 77; // Nombre d'elements dans l'interface
    interface->gui=(t_gui_element*)malloc(t * sizeof(t_gui_element)); // On alloue la mmoire de ces lements
    interface->gui_actif = NULL;
    interface->pointeur.x = 0;
    interface->pointeur.y = 0;

/*
    RESSOURCES (image)
*/

    interface->nbr_textures = 8;
    interface->texture = (SDL_Surface **)malloc(interface->nbr_textures * sizeof(SDL_Surface *));

    sprintf(str, "%s%s", RESSOURCES_DIR, "background.png"); // On rcupre le chemin de l'image
    stemp = IMG_Load(str); // On charge l'image
    if ( !stemp ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->texture[0] = SDL_DisplayFormat(stemp); // Acclration importante du blit
    SDL_FreeSurface(stemp);

    sprintf(str, "%s%s", RESSOURCES_DIR, "bouton1.png"); // On rcupre le chemin de l'image
    stemp = IMG_Load(str); // On charge l'image
    if ( !stemp ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->texture[1] = stemp; // Pas d'acclration (alpha...)

    sprintf(str, "%s%s", RESSOURCES_DIR, "bouton2.png"); // On rcupre le chemin de l'image
    stemp = IMG_Load(str); // On charge l'image
    if ( !stemp ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->texture[2] = SDL_DisplayFormat(stemp); // Acclration importante du blit
    SDL_FreeSurface(stemp);

    sprintf(str, "%s%s", RESSOURCES_DIR, "bouton3.png"); // On rcupre le chemin de l'image
    stemp = IMG_Load(str); // On charge l'image
    if ( !stemp ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->texture[3] = SDL_DisplayFormat(stemp); // Acclration importante du blit
    SDL_FreeSurface(stemp);

    sprintf(str, "%s%s", RESSOURCES_DIR, "switch1.png"); // On rcupre le chemin de l'image
    stemp = IMG_Load(str); // On charge l'image
    if ( !stemp ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->texture[4] = SDL_DisplayFormat(stemp); // Acclration importante du blit
    SDL_FreeSurface(stemp);

    sprintf(str, "%s%s", RESSOURCES_DIR, "saisie.png"); // On rcupre le chemin de l'image
    stemp = IMG_Load(str); // On charge l'image
    if ( !stemp ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->texture[5] = SDL_DisplayFormat(stemp); // Acclration importante du blit
    SDL_FreeSurface(stemp);

    sprintf(str, "%s%s", RESSOURCES_DIR, "switchab.png"); // On rcupre le chemin de l'image
    stemp = IMG_Load(str); // On charge l'image
    if ( !stemp ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->texture[6] = SDL_DisplayFormat(stemp); // Acclration importante du blit
    SDL_FreeSurface(stemp);

    sprintf(str, "%s%s", RESSOURCES_DIR, "apercu.png"); // On rcupre le chemin de l'image
    stemp = IMG_Load(str); // On charge l'image
    if ( !stemp ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->texture[7] = SDL_DisplayFormat(stemp); // Acclration importante du blit
    SDL_FreeSurface(stemp);


/*
    DESIGN DU MENU
*/

n=0; /// ELEMENT 0 :  Arrire plan du Menu
    interface->gui[n].type=IMAGE; // Element de type Image
    interface->gui[n].image = interface->texture[0];
    interface->gui[n].valeur=NULL;// Pas de Texte
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=0; // On Positionne le fond dans le coin haut gauche
    interface->gui[n].position.y=0;// En haut
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=0; // On ne rogne pas l'image
    interface->gui[n].crop.h=0; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=1; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=FENETRE; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_RIEN; // L'image sera libr  la fin

/*
    MENU DU PROGRAMME
*/

n++; /// ELEMENT 2 :  Titre "Meningix"
    interface->gui[n].type=BOUTON; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Meningix 1.0bta") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Meningix 1.0bta"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=interface->fenetre->w/2-80; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=0; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=160; // Pas de crop
    interface->gui[n].crop.h=24; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=1; // Visible
    interface->gui[n].style=STYLE_ORANGE|STYLE_CENTRE; // Visible
    interface->gui[n].groupe=FENETRE; // Element du Menu Principal
    interface->gui[n].flag=AIDE; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 6 :  Bouton Crer
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[1]; // On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Crer")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Crer");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Crer / Charger un Rseau de Neurones") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Crer / Charger un Rseau de Neurones");// On Dfinit le Texte
    interface->gui[n].position.x=4; // On Positionne le bouton au milieu
    interface->gui[n].position.y=28;// En haut du menu
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=160; // On ne rogne pas l'image
    interface->gui[n].crop.h=32; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=1; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU; // Element du Menu Principal
    interface->gui[n].flag=CREER; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 3 :  Bouton Rseau
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[1]; // On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Rseau")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Rseau");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Voir et Travailler avec le Rseau Charg") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Voir et Travailler avec le Rseau Charg");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[n-1].position.x+interface->gui[n-1].crop.w; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=interface->gui[n-1].position.y;// Sur la mme ligne
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=160; // On ne rogne pas l'image
    interface->gui[n].crop.h=32; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU; // Element du Menu Principal
    interface->gui[n].flag=RESEAU; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 8 :  Bouton Quitter
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[1]; // On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Quitter [ESC]")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Quitter [ESC]");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Quitter le Programme (raccourci = chap)") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Quitter le Programme (raccourci = chap)");// On Dfinit le Texte
    interface->gui[n].position.x=interface->fenetre->w-interface->gui[n].image->w-2; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=interface->gui[n-1].position.y;// Sur la mme ligne
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=160; // On ne rogne pas l'image
    interface->gui[n].crop.h=32; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=1; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU; // Element du Menu Principal
    interface->gui[n].flag=QUITTER; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 8 :  Bouton Options
    interface->gui[n].type=BOUTON; // Element de type Image
    sprintf(str, "%s%s", RESSOURCES_DIR, "home.png"); // On rcupre le chemin de l'image
    interface->gui[n].image = IMG_Load(str); // On charge l'image
    if ( !stemp ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n].valeur= NULL;
    interface->gui[n].info=(char*)malloc(strlen("Aide / Prsentation") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Aide / Prsentation");// On Dfinit le Texte
    interface->gui[n].position.x=interface->fenetre->w-interface->gui[n].image->w-162; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=interface->gui[n-1].position.y;// Sur la mme ligne
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=48; // On ne rogne pas l'image
    interface->gui[n].crop.h=32; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=1; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU; // Element du Menu Principal
    interface->gui[n].flag=AIDE; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR|FREE_IMAGE; // L'image sera libr  la fin

/*
    PRESENTATION
*/

n++; /// ELEMENT 2 :  Titre "Crer un Rseau"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Meningix") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Meningix"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=8; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=72; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=1; // Visible
    interface->gui[n].style=STYLE_GROS|STYLE_ORANGE; // En gros
    interface->gui[n].groupe=PRESENTATION; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Prsentation du programme
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(1024); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Ce programme utilise le principe des rseaux de neurones pour modliser un \n");
    sprintf(interface->gui[n].valeur,"%ssystme en deux dimensions constitu de points pouvant reprsenter des courbes\n",interface->gui[n].valeur);
    sprintf(interface->gui[n].valeur,"%sou bien des formes (identifies par une couleur spcifique).\n\n",interface->gui[n].valeur);
    sprintf(interface->gui[n].valeur,"%sIl permet ainsi d'apprendre  un rseau de neurones un systme de points dfinis\n",interface->gui[n].valeur);
    sprintf(interface->gui[n].valeur,"%spar des fonctions mathmatiques, ou bien placs de manire personnalise.  l'aide de\n",interface->gui[n].valeur);
    sprintf(interface->gui[n].valeur,"%scalculs lors de la phase d'apprentissage, le rseau va pouvoir reproduire avec plus\n",interface->gui[n].valeur);
    sprintf(interface->gui[n].valeur,"%sou moins de fidlit ce systme.",interface->gui[n].valeur);

    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=interface->fenetre->w/2; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=1; // Visible
    interface->gui[n].style=STYLE_CENTRE; // En gros
    interface->gui[n].groupe=PRESENTATION; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Texte "Indication d'utilisation"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("> Indication d'Utilisation") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"> Indication d'Utilisation"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=32; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=300; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=1; // Visible
    interface->gui[n].style=STYLE_ORANGE; // En gros
    interface->gui[n].groupe=PRESENTATION; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Prsentation du programme
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(1024); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"- Pour crer un rseau de neurones, allez dans le menu Crer, et Remplissez les champs.\n");
    sprintf(interface->gui[n].valeur,"%s- Obtenez une description des champs en les survolant.\n",interface->gui[n].valeur);
    sprintf(interface->gui[n].valeur,"%s- Le menu Crer permet galement de charger des rseaux de neurones.\n",interface->gui[n].valeur);
    sprintf(interface->gui[n].valeur,"%s- Lorsqu'un rseau est cre/charg, vous pouvez accder au menu Rseau.\n",interface->gui[n].valeur);
    sprintf(interface->gui[n].valeur,"%s- Le menu Rseau donne des indications sur le rseau actuel (rsultat, statistiques).\n",interface->gui[n].valeur);
    sprintf(interface->gui[n].valeur,"%s- Vous pouvez galement modifier et poursuivre un Apprentissage.\n",interface->gui[n].valeur);
    sprintf(interface->gui[n].valeur,"%s- Le menu Rseau permet de sauvegarder le Rseau, sous forme de fichier \".mgx\".\n",interface->gui[n].valeur);

    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=64; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=1; // Visible
    interface->gui[n].style=0; // En gros
    interface->gui[n].groupe=PRESENTATION; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Prsentation du programme
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Dvelopp en L1  l'EFREI par Loc Belmonte et Rmi Jarasson") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Dvelopp en L1  l'EFREI par Loc Belmonte et Rmi Jarasson"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=300; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->fenetre->h - 64; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=1; // Visible
    interface->gui[n].style=STYLE_ORANGE; // En gros
    interface->gui[n].groupe=PRESENTATION; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Prsentation du programme
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("http://projects.artistix.fr/meningix") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"http://projects.artistix.fr/meningix"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=500; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->fenetre->h - 48; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=1; // Visible
    interface->gui[n].style=0; // En gros
    interface->gui[n].groupe=PRESENTATION; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber
/*
    MENU NOUVEAU
*/

n++; /// ELEMENT 2 :  Titre "Crer un Rseau"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Crer un Rseau") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Crer un Rseau"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=8; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=72; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_GROS|STYLE_ORANGE; // En gros
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Label "Charger un Rseau existant"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("> Charger un Rseau existant:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"> Charger un Rseau existant:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=96; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_ORANGE; // En gros
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Label "Nom du Rseau"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Nom du Rseau:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Nom du Rseau:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=128; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+24; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie du Nom du Rseau
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5];// On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Le Nom du Rseau permet de le Sauvegarder pour pouvoir le Charger") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Le Nom du Rseau permet de le Sauvegarder pour pouvoir le Charger");// On Dfinit le Texte
    interface->gui[n].position.x=256; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=256; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=NOUVEAU_NOM; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 8 :  Bouton Charger
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[3];// On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Charger")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Charger");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Charge un rseau pr-existant (prciser le nom)") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Charge un rseau pr-existant (prciser le nom)");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[n-1].position.x+interface->gui[n-1].crop.w; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=interface->gui[n-1].position.y;// Sur la mme ligne
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=128; // On ne rogne pas l'image
    interface->gui[n].crop.h=24; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=CHARGER; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin


n++; /// ELEMENT 2 :  Label "Configuration des Couches du Rseau"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("> Configuration des Couches du Rseau:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"> Configuration des Couches du Rseau:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=96; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_ORANGE; // En gros
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber



n++; /// ELEMENT 12 :  Saisie des couches
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5]; // On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Un Rseau est compos de neurones organiss en Couches.") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Un Rseau est compos de neurones organiss en Couches.");// On Dfinit le Texte
    interface->gui[n].position.x=256; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y+24; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=256; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=COUCHES; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 2 :  Informations sur la saisie des couches
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("(Entrez le nombre de neurones composant chaque couche, et sparez par des espaces)") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"(Entrez le nombre de neurones composant chaque couche, et sparez par des espaces)"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=interface->fenetre->w/2; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+24; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_CENTRE; // En gros
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Label "Configuration de l'Apprentissage"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("> Configuration de l'Apprentissage:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"> Configuration de l'Apprentissage:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=96; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_ORANGE; // En gros
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Label "Facteur"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Facteur Epsilon:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Facteur Epsilon:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=128; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+24; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie de Epsilon
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5]; // On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Le Facteur d'Apprentissage Epsilon dtermine le degr de correction des Poids") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Le Facteur d'Apprentissage Epsilon dtermine le degr de correction des Poids");// On Dfinit le Texte
    interface->gui[n].position.x=256; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=128; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=NOUVEAU_EPSILON; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 2 :  Label "Seuil"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Seuil:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Seuil:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=interface->fenetre->w/2 ; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie du Seuil
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5]; // On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Le Seuil d'Apprentissage dtermine l'erreur maximale tolre et limite la dure du processus") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Le Seuil d'Apprentissage dtermine l'erreur maximale tolre et limite la dure du processus");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[n-1].position.x+64; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=128; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=NOUVEAU_SEUIL; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 2 :  Label "Configuration des Points"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("> Configuration des Points:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"> Configuration des Points:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=96; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_ORANGE; // En gros
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Label "Coordonnes Cartsiennes"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Coordonnes Cartsiennes") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Coordonnes Cartsiennes"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=128; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+24; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=0; // En gros
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Switch Coordonnes
    interface->gui[n].type=SWITCH; // Element de type Switch
    interface->gui[n].valeur=NULL;
    interface->gui[n].image = interface->texture[6]; // On charge l'image du switch
    interface->gui[n].info=NULL;
    interface->gui[n].position.x=interface->gui[n-1].position.x+212; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y; // 4px du bord haut
    interface->gui[n].crop.x=0; // Bord Gauche
    interface->gui[n].crop.y=0; // Haut
    interface->gui[n].crop.w=48; // largeur 160px
    interface->gui[n].crop.h=24;// Hauteur 32 px
    interface->gui[n].etat = INACTIF;
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_CENTRE; // Normal
    interface->gui[n].groupe=MENU_CREER; // Appartient  la Barre latrale
    interface->gui[n].flag=COORD;  // Action: Afficher/Masquer le menu deroulant du type de terrain
    interface->gui[n].free=FREE_RIEN; // On libre l'image ET le texte

n++; /// ELEMENT 2 :  Label "Coordonnes Polaires"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Coordonnes Polaires") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Coordonnes Polaires"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=interface->gui[n-1].position.x+interface->gui[n-1].crop.w+4; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=0; // En gros
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Label "Facteur"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Forme:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Forme:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=128; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+24; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Switch "Forme"
    interface->gui[n].type=SWITCH; // Element de type Switch
    interface->gui[n].valeur=(char*)malloc(32); // On alloue la mmoire pour le texte du bouton (max 31 caractres)
    strcpy(interface->gui[n].valeur,"Spirale"); // On inscrit un texte dans l'element
    interface->gui[n].image = interface->texture[4]; // On charge l'image du switch
    interface->gui[n].info=(char*)malloc(strlen("Choisissez la Forme  apprendre:") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Choisissez la Forme  apprendre:");// On Dfinit le Texte
    interface->gui[n].position.x=256; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y; // 4px du bord haut
    interface->gui[n].crop.x=0; // Bord Gauche
    interface->gui[n].crop.y=0; // Haut
    interface->gui[n].crop.w=160; // largeur 160px
    interface->gui[n].crop.h=24;// Hauteur 32 px
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_CENTRE; // Normal
    interface->gui[n].groupe=MENU_CREER; // Appartient  la Barre latrale
    interface->gui[n].flag=SWITCH_FORME;  // Action: Afficher/Masquer le menu deroulant du type de terrain
    interface->gui[n].free=FREE_VALEUR; // On libre l'image ET le texte

/*
    Configuration de la Spirale
*/

n++; /// ELEMENT 2 :  Label "Nombre de Points"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Nb de Points:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Nb de Points:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=interface->gui[n-1].position.x+interface->gui[n-1].crop.w+8; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=CONFIG_SPIRALE; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber


n++; /// ELEMENT 12 :  Saisie du Nombre de Points
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5]; // On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Nombre de points constituant les spirales (total)") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Nombre de points constituant les spirales (total)");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[n-1].position.x+128; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=128; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=CONFIG_SPIRALE; // Element du Menu Principal
    interface->gui[n].flag=SPIRALE_POINTS; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 2 :  Label "Phase"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Phase:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Phase:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=128; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=CONFIG_SPIRALE; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie de la Phase
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5]; // On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Angle de Dpart de la Gnration des 2 Spirales (en Radians)") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Angle de Dpart de la Gnration des 2 Spirales (en Radians)");// On Dfinit le Texte
    interface->gui[n].position.x=256; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=128; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=CONFIG_SPIRALE; // Element du Menu Principal
    interface->gui[n].flag=SPIRALE_PHASE; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 2 :  Label "Offset"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Offset:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Offset:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=interface->fenetre->w/2 ; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=CONFIG_SPIRALE; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie de l'Offset
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5]; // On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Nombre de points de dpart  ignorer") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Nombre de points de dpart  ignorer");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[n-1].position.x+64; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=128; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=CONFIG_SPIRALE; // Element du Menu Principal
    interface->gui[n].flag=SPIRALE_OFFSET; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

/*
    Reste de l'cran
*/

n++; /// ELEMENT 2 :  Label "Configuration de l'Apparence"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("> Configuration de l'Apparence:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"> Configuration de l'Apparence:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=96; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_ORANGE; // En gros
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Label "Couleur A"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Couleur A:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Couleur A:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=128; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+24; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie de la couleur A
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5]; // On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Couleur de la Premire Forme/Courbe") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Couleur de la Premire Forme/Courbe");// On Dfinit le Texte
    interface->gui[n].position.x=256; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=64; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=NOUVEAU_COULEUR_A; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 2 :  Label "Couleur B"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Couleur B:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Couleur B:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=interface->fenetre->w/2 ; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie de la Couleur B
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5]; // On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Couleur de la Seconde Forme/Courbe") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Couleur de la Seconde Forme/Courbe");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[n-1].position.x+128; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=64; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=NOUVEAU_COULEUR_B; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 2 :  Texte d'indication de la saisie des couleurs
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("(Entrez la couleur sous sa forme hexadcimale RRGGBB  [avec R,G,B de 0  9 et de A  F])") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"(Entrez la couleur sous sa forme hexadcimale RRGGBB [avec R,G,B de 0  9 et de A  F])"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=interface->fenetre->w/2; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+24; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_CENTRE; // En gros
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 8 :  Bouton Apprendre
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[1]; // On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Apprendre")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Apprendre");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Lancer l'Apprentissage du Rseau") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Lancer l'Apprentissage du Rseau");// On Dfinit le Texte
    interface->gui[n].position.x=(interface->fenetre->w-interface->gui[n].image->w)/2; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=interface->gui[n-1].position.y+32;// Sur la mme ligne
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=160; // On ne rogne pas l'image
    interface->gui[n].crop.h=32; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_CREER; // Element du Menu Principal
    interface->gui[n].flag=NOUVEAU_APPRENDRE; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin

/*
    Configuration de la Forme Personnalise
*/

interface->gui_taille = n + 1;
temp=obtenir_element(interface,SWITCH_FORME);

n++; /// ELEMENT 8 :  Bouton Dessiner
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[3]; // On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Dessiner")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Dessiner");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Dessinez  la souris vos propres Formes") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Dessinez  la souris vos propres Formes");// On Dfinit le Texte
    interface->gui[n].position.x=(interface->fenetre->w-interface->gui[n].image->w)/2; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=interface->gui[temp].position.y+32;// Sur la mme ligne
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=128; // On ne rogne pas l'image
    interface->gui[n].crop.h=24; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=CONFIG_PERSO; // Element du Menu Principal
    interface->gui[n].flag=DESSINER; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin



/*
    Menu Droulant SWITCH_FORME
*/

interface->gui_taille = n + 1;
temp=obtenir_element(interface,SWITCH_FORME);

n++; /// ELEMENT 2 :  element 1 du menu droulant SWITCH_FORME
    interface->gui[n].type=BOUTON; // Element de type Bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Spirale") + 1); // On alloue la mmoire pour le texte du bouton
    strcpy(interface->gui[n].valeur,"Spirale"); // On inscrit le texte dans l'element
    interface->gui[n].image = interface->texture[2]; // On charge l'image du bouton
    interface->gui[n].info=(char*)malloc(strlen("Double Spirale") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Double Spirale");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[temp].position.x; // Position en X du bouton (Hrite)
    interface->gui[n].position.y=interface->gui[temp].position.y+interface->gui[n-1].crop.h;// Position en Y du bouton (Hrite)
    interface->gui[n].crop.x=0; // Bord Gauche
    interface->gui[n].crop.y=0; // Haut
    interface->gui[n].crop.w=128; // largeur 160px
    interface->gui[n].crop.h=24;// Hauteur 32 px
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_NOIR; // En Noir
    interface->gui[n].groupe=DEROUL_FORME; // Appartient au menu droulant du Type
    interface->gui[n].flag=FORME_SPIRALE; // Action: Parametrer le type du terrain  SOL
    interface->gui[n].free=FREE_VALEUR; // On libre l'image ET le texte.

n++; /// ELEMENT 2 :  element 2 du menu droulant SWITCH_FORME
    interface->gui[n].type=BOUTON; // Element de type Bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Personnalise") + 1); // On alloue la mmoire pour le texte du bouton
    strcpy(interface->gui[n].valeur,"Personnalise"); // On inscrit le texte dans l'element
    interface->gui[n].image = interface->texture[2]; // On charge l'image du champ
    interface->gui[n].info=(char*)malloc(strlen("Dessiner une Forme Personnalise") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Dessiner une Forme Personnalise");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[n-1].position.x; // Position en X du bouton (Hrite)
    interface->gui[n].position.y=interface->gui[n-1].position.y+interface->gui[n-1].crop.h;// Position en Y du bouton (Hrite)
    interface->gui[n].crop.x=0; // Bord Gauche
    interface->gui[n].crop.y=0; // Haut
    interface->gui[n].crop.w=128; // largeur 160px
    interface->gui[n].crop.h=24;// Hauteur 32 px
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_NOIR; // En Noir
    interface->gui[n].groupe=DEROUL_FORME; // Appartient au menu droulant du Type
    interface->gui[n].flag=FORME_PERSO; // Action: Parametrer le type du terrain  SOL
    interface->gui[n].free=FREE_VALEUR; // On libre l'image ET le texte.

/*
    MENU RESEAU
*/

n++; /// ELEMENT 2 :  Titre "Rseau"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Rseau") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Rseau"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=8; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=72; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_GROS|STYLE_ORANGE; // En gros
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Statistiques
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(512); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Aucune Statistiques"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=8; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=0; // En gros
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=STATISTIQUES; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Titre "Apprentissage"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Apprentissage") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Apprentissage"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=608; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=72;// Sur la mme ligne
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_GROS|STYLE_ORANGE; // En gros
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Label "Facteur"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Facteur Epsilon:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Facteur Epsilon:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=620; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie de Epsilon
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5]; // On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Le Facteur d'Apprentissage Epsilon dtermine le degr de correction des Poids (Modifier)") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Le Facteur d'Apprentissage Epsilon dtermine le degr de correction des Poids (Modifier)");// On Dfinit le Texte
    interface->gui[n].position.x=620; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y+24; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=160; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=EPSILON; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 2 :  Label "Seuil"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Seuil:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Seuil:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=620; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie du Seuil
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5]; // On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Le Seuil d'Apprentissage est l'erreur maximale tolre et limite la dure du processus (Modifier)") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Le Seuil d'Apprentissage est l'erreur maximale tolre et limite la dure du processus (Modifier)");// On Dfinit le Texte
    interface->gui[n].position.x=620; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y+24; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=160; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=SEUIL; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 2 :  Titre "Apprentissage"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Apparence") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Apparence"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=608; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=interface->gui[n-1].position.y+24; // Sur la mme ligne
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_GROS|STYLE_ORANGE; // En gros
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Label "> Couleurs (en Hxa):"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("> Couleurs (en Hxa):") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"> Couleurs (en Hxa):"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=608; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_ORANGE; // En gros
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Label "A :"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("A :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"A :"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=640; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie de la Couleur A
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5]; // On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Couleur de la Premire Forme/Courbe (Modifier)") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Couleur de la Premire Forme/Courbe (Modifier)");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[n-1].position.x+32; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=64; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=COULEUR_A; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 2 :  Label "B :"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("B :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"B :"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=640; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie de la Couleur B
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5]; // On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Couleur de la Seconde Forme/Courbe (Modifier)") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Couleur de la Seconde Forme/Courbe (Modifier)");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[n-1].position.x+32; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=64; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=COULEUR_B; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

// Boutons du Menu Rseau

n++; /// ELEMENT 8 :  Bouton Tracer
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[1]; // On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Tracer")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Tracer");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Tracer le Rsultat du Dernier Apprentissage") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Tracer le Rsultat du Dernier Apprentissage");// On Dfinit le Texte
    interface->gui[n].position.x=620; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=400;// Sur la mme ligne
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=160; // On ne rogne pas l'image
    interface->gui[n].crop.h=32; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=TRACER; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 8 :  Bouton Amliorer
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[1]; // On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Amliorer")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Amliorer");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Continuer l'Apprentissage") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Continuer l'Apprentissage");// On Dfinit le Texte
    interface->gui[n].position.x=620; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=interface->gui[n-1].position.y+interface->gui[n-1].crop.h+4;// Sur la mme ligne
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=160; // On ne rogne pas l'image
    interface->gui[n].crop.h=32; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=APPRENDRE; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin

// Menu de Sauvegarde
n++; /// ELEMENT 2 :  Titre "Conserver le Rseau ?"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Conserver le Rseau ?") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Conserver le Rseau ?"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=8; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=470;// Sur la mme ligne
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_GROS|STYLE_ORANGE; // En gros
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 2 :  Label "Nom du Rseau"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Nom du Rseau:") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Nom du Rseau:"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=128; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+38; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT 12 :  Saisie du Nom du Rseau
    interface->gui[n].type=SAISIE; // Element de type Saisie
    interface->gui[n].image = interface->texture[5];// On charge l'image du champ
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=(char*)malloc(strlen("Veuillez entrer le nom du rseau pour le Sauvegarder") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Veuillez entrer le nom du rseau pour le Sauvegarder");// On Dfinit le Texte
    interface->gui[n].position.x=interface->fenetre->w/2-128; // Position en X du champ
    interface->gui[n].position.y=interface->gui[n-1].position.y; // Position en Y du champ
    interface->gui[n].crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n].crop.w=256; // Largeur de 160
    interface->gui[n].crop.h=24;  // Hauteur de 24
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=NOM; // Pas d'action lors de sa validation
    interface->gui[n].free=FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 8 :  Bouton Sauvegarder
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[1]; // On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Sauvegarder")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Sauvegarder");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Sauvegarder l'intgralit du Rseau") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Sauvegarder l'intgralit du Rseau");// On Dfinit le Texte
    interface->gui[n].position.x=interface->fenetre->w/2 - 160; // On Positionne le bouton  gauche du mileu de la fenetre
    interface->gui[n].position.y=interface->fenetre->h - 28 - 32;// Juste au dessus de la barre de messages
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=160; // On ne rogne pas l'image
    interface->gui[n].crop.h=32; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=SAUVEGARDER; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 8 :  Bouton Dtruire
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[1]; // On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Dtruire")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Dtruire");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Dtruire le Rseau. Attention, il sera dfinitivement perdu") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Dtruire le Rseau. Attention, il sera dfinitivement perdu");// On Dfinit le Texte
    interface->gui[n].position.x=interface->fenetre->w/2; // On Positionne le bouton  gauche du mileu de la fenetre
    interface->gui[n].position.y=interface->gui[n-1].position.y;// Juste au dessus de la barre de messages
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=160; // On ne rogne pas l'image
    interface->gui[n].crop.h=32; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_RESEAU; // Element du Menu Principal
    interface->gui[n].flag=DETRUIRE; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin

/*
    Ligne de Message
*/

n++; /// ELEMENT 2 :  Messages
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(SAISIE_MAX + 1); // On alloue la mmoire pour le texte
    interface->gui[n].valeur[0]=0;
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=4; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->fenetre->h-24; // En bas de la fenetre
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=FENETRE; // Element du Menu Principal
    interface->gui[n].flag=MESSAGE; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT ? :  Cadre d'affichage
    interface->gui[n].type = IMAGE; // Element de type Image

    // Chagement du cadre par dfaut...
    sprintf(str, "%s%s", RESSOURCES_DIR, "apercu.png"); // On rcupre le chemin de l'image
    stemp = IMG_Load(str); // On charge l'image
    if ( !stemp ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n].image = SDL_DisplayFormat(stemp); // Acclration importante du blit
    SDL_FreeSurface(stemp);

    //interface->gui[n].image = SDL_CreateRGBSurface(SDL_HWSURFACE, 400, 400, 32, 0, 0, 0, 0); // Nouvelle surface
    interface->gui[n].valeur = NULL; // On n'alloue pas de mmoire pour le texte
    interface->gui[n].info = NULL; // Pas de Description
    interface->gui[n].position.x = (interface->fenetre->w - interface->gui[n].image->w) / 2; // On le positionne au milieu de la fentre
    interface->gui[n].position.y = (interface->fenetre->h - interface->gui[n].image->h) / 2 - 30; // Et lgrement plus haut
    interface->gui[n].crop.x = 0; // Pas de crop
    interface->gui[n].crop.y = 0; // Pas de crop
    interface->gui[n].crop.w = 400; // Pas de crop
    interface->gui[n].crop.h = 400; // Pas de crop
    interface->gui[n].etat = INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible = 0; // Visible
    interface->gui[n].style = 0; // En gros
    interface->gui[n].groupe = MENU_RESEAU; // Element affich lors de l'apprentissage
    interface->gui[n].flag = CADRE_RESULTAT; // Pas d'action
    interface->gui[n].free = FREE_IMAGE; // Le texte sera liber

/*
    MENU DESSINER
*/

n++; /// ELEMENT 2 :  Titre "Dessiner"
    interface->gui[n].type=TEXTE; // Element de type Texte
    interface->gui[n].image=NULL; // Pas d'image
    interface->gui[n].valeur=(char*)malloc(strlen("Dessiner") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n].valeur,"Dessiner"); // On inscrit le texte dans l'element
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=8; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=72; // 4px du bord haut
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=0; // Pas de crop
    interface->gui[n].crop.h=0; // Pas de crop
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_GROS|STYLE_ORANGE; // En gros
    interface->gui[n].groupe=MENU_DESSIN; // Element du Menu Principal
    interface->gui[n].flag=AUCUN; // Pas d'action
    interface->gui[n].free=FREE_VALEUR; // Le texte sera liber

n++; /// ELEMENT ? :  Surface de dessin
    interface->gui[n].type = IMAGE; // Element de type Image
    interface->gui[n].image = SDL_CreateRGBSurface(SDL_HWSURFACE, 400, 400, 32, 0, 0, 0, 0); // Nouvelle surface
    interface->gui[n].valeur = NULL; // On n'alloue pas de mmoire pour le texte
    interface->gui[n].info = NULL; // Pas de Description
    interface->gui[n].position.x = (interface->fenetre->w - interface->gui[n].image->w) / 2; // On le positionne au milieu de la fentre
    interface->gui[n].position.y = (interface->fenetre->h - interface->gui[n].image->h) / 2 - 30; // Et lgrement plus haut
    interface->gui[n].crop.x = 0; // Pas de crop
    interface->gui[n].crop.y = 0; // Pas de crop
    interface->gui[n].crop.w = 400; // Pas de crop
    interface->gui[n].crop.h = 400; // Pas de crop
    interface->gui[n].etat = INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible = 0; // Visible
    interface->gui[n].style = 0; // En gros
    interface->gui[n].groupe = MENU_DESSIN; // Element affich lors de l'apprentissage
    interface->gui[n].flag = CADRE_DESSIN; // Pas d'action
    interface->gui[n].free = FREE_IMAGE; // Le texte sera liber

n++; /// ELEMENT 2 :  Switch "Dessin"
    interface->gui[n].type=SWITCH; // Element de type Switch
    interface->gui[n].valeur=(char*)malloc(32); // On alloue la mmoire pour le texte du bouton (max 31 caractres)
    strcpy(interface->gui[n].valeur,"Forme A"); // On inscrit un texte dans l'element
    interface->gui[n].image = interface->texture[4]; // On charge l'image du switch
    interface->gui[n].info=(char*)malloc(strlen("Choisissez la Forme  Dessiner:") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Choisissez la Forme  Dessiner:");// On Dfinit le Texte
    interface->gui[n].position.x=20; // On le positionne  4 px du bord gauche du fond
    interface->gui[n].position.y=interface->gui[n-1].position.y+32; // 4px du bord haut
    interface->gui[n].crop.x=0; // Bord Gauche
    interface->gui[n].crop.y=0; // Haut
    interface->gui[n].crop.w=160; // largeur 160px
    interface->gui[n].crop.h=24;// Hauteur 32 px
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_CENTRE; // Normal
    interface->gui[n].groupe=MENU_DESSIN; // Appartient  la Barre latrale
    interface->gui[n].flag=SWITCH_DESSIN;  // Action: Afficher/Masquer le menu deroulant du type de terrain
    interface->gui[n].free=FREE_VALEUR; // On libre l'image ET le texte

n++; /// ELEMENT 8 :  Bouton Annuler
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[1]; // On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Annuler")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Annuler");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Annuler le dernier placement") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Annuler le dernier placement");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[n-1].position.x; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=interface->gui[n-1].position.y+32;;// Sur la mme ligne
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=160; // On ne rogne pas l'image
    interface->gui[n].crop.h=32; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_DESSIN; // Element du Menu Principal
    interface->gui[n].flag=ANNULER; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin

n++; /// ELEMENT 8 :  Bouton Effacer
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[1]; // On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Effacer")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Effacer");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Effacer le Dessin") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Effacer le Dessin");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[n-1].position.x; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=interface->gui[n-1].position.y+32;;// Sur la mme ligne
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=160; // On ne rogne pas l'image
    interface->gui[n].crop.h=32; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_DESSIN; // Element du Menu Principal
    interface->gui[n].flag=EFFACER; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin

interface->gui_taille = n + 1;
temp=obtenir_element(interface,SWITCH_DESSIN);

n++; /// ELEMENT 2 :  element 1 du menu droulant SWITCH_DESSIN
    interface->gui[n].type=BOUTON; // Element de type Bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Forme A") + 1); // On alloue la mmoire pour le texte du bouton
    strcpy(interface->gui[n].valeur,"Forme A"); // On inscrit le texte dans l'element
    interface->gui[n].image = interface->texture[2]; // On charge l'image du bouton
    interface->gui[n].info=(char*)malloc(strlen("Placer des points de la Forme A") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Placer des points de la Forme A");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[temp].position.x; // Position en X du bouton (Hrite)
    interface->gui[n].position.y=interface->gui[temp].position.y+interface->gui[temp].crop.h;// Position en Y du bouton (Hrite)
    interface->gui[n].crop.x=0; // Bord Gauche
    interface->gui[n].crop.y=0; // Haut
    interface->gui[n].crop.w=128; // largeur 160px
    interface->gui[n].crop.h=24;// Hauteur 32 px
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_NOIR; // En Noir
    interface->gui[n].groupe=DEROUL_DESSIN; // Appartient au menu droulant du Type
    interface->gui[n].flag=FORME_A; // Action: Parametrer le type du terrain  SOL
    interface->gui[n].free=FREE_VALEUR; // On libre l'image ET le texte.

n++; /// ELEMENT 2 :  element 2 du menu droulant SWITCH_DESSIN
    interface->gui[n].type=BOUTON; // Element de type Bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Forme B") + 1); // On alloue la mmoire pour le texte du bouton
    strcpy(interface->gui[n].valeur,"Forme B"); // On inscrit le texte dans l'element
    interface->gui[n].image = interface->texture[2]; // On charge l'image du champ
    interface->gui[n].info=(char*)malloc(strlen("Placer des points de la Forme B") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Placer des points de la Forme B");// On Dfinit le Texte
    interface->gui[n].position.x=interface->gui[n-1].position.x; // Position en X du bouton (Hrite)
    interface->gui[n].position.y=interface->gui[n-1].position.y+interface->gui[n-1].crop.h;// Position en Y du bouton (Hrite)
    interface->gui[n].crop.x=0; // Bord Gauche
    interface->gui[n].crop.y=0; // Haut
    interface->gui[n].crop.w=128; // largeur 160px
    interface->gui[n].crop.h=24;// Hauteur 32 px
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style=STYLE_NOIR; // En Noir
    interface->gui[n].groupe=DEROUL_DESSIN; // Appartient au menu droulant du Type
    interface->gui[n].flag=FORME_B; // Action: Parametrer le type du terrain  SOL
    interface->gui[n].free=FREE_VALEUR; // On libre l'image ET le texte.

n++; /// ELEMENT 8 :  Bouton Retour
    interface->gui[n].type=BOUTON; // Element de type Image
    interface->gui[n].image = interface->texture[1]; // On charge l'image du bouton
    interface->gui[n].valeur=(char*)malloc(strlen("Retour")+1);// On alloue la taille du texte
    sprintf(interface->gui[n].valeur,"Retour");// On Dfinit le Texte
    interface->gui[n].info=(char*)malloc(strlen("Retourner au Menu Crer") + 1);// Pas de Description
    sprintf(interface->gui[n].info,"Retourner au Menu Crer");// On Dfinit le Texte
    interface->gui[n].position.x=620; // On Positionne le bouton a cot du bouton prcdent
    interface->gui[n].position.y=432;// Sur la mme ligne
    interface->gui[n].crop.x=0; // On prend toute l'image
    interface->gui[n].crop.y=0; // On prend toute l'image
    interface->gui[n].crop.w=160; // On ne rogne pas l'image
    interface->gui[n].crop.h=32; // On ne rogne pas l'image
    interface->gui[n].etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n].visible=0; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=MENU_DESSIN; // Element du Menu Principal
    interface->gui[n].flag=CREER; // On passe au Menu Rejoindre
    interface->gui[n].free=FREE_VALEUR; // L'image sera libr  la fin

/*
n++; /// ELEMENT 68 : POINTEUR SOURIS
    interface->gui[n].type=IMAGE; // Element de type Texte
    sprintf(str,"%s%s",RESSOURCES_DIR,"curseur.png"); // On rcupre le chemin du curseur
    interface->gui[n].image=IMG_Load(str);// On charge l'image
    interface->gui[n].valeur=NULL; // On alloue la mmoire pour le texte
    interface->gui[n].info=NULL;// Pas de Description
    interface->gui[n].position.x=0; // Position en X du texte
    interface->gui[n].position.y=0; // Position en Y du texte
    interface->gui[n].crop.x=0; // Pas de crop
    interface->gui[n].crop.y=0; // Pas de crop
    interface->gui[n].crop.w=24; // Pas de crop
    interface->gui[n].crop.h=24; // Pas de crop
    interface->gui[n].visible=1; // Visible
    interface->gui[n].style = 0; // Pas de style particulier
    interface->gui[n].groupe=FENETRE; // Appartient au menu droulant du Type
    interface->gui[n].flag=POINTEUR; // Pas d'action
    interface->gui[n].free=FREE_IMAGE; // On libre le texte allou

    interface->pointeur.x = 0;
    interface->pointeur.y = 0;
*/

  interface->gui_taille = t; // Nombre d'elements dans l'interface
  return;
}

// Supprime les donnes de l'interface
void liberer_interface(t_interface* interface)
{
    long n; // Compteur

    TTF_CloseFont(interface->font);// On supprime la police de caractres
    TTF_CloseFont(interface->font_gros);// On supprime la police de gros caractres
    for(n = 0; n < interface->nbr_textures; n++) {SDL_FreeSurface(interface->texture[n]);} // On supprime les images / ressources
    free(interface->texture);

    for (n=0;n<interface->gui_taille;n++) // Pour chaque element du GUI
    {
        if (interface->gui[n].free & FREE_IMAGE) // Si on doit supprimer l'image
        {
            SDL_FreeSurface(interface->gui[n].image); // On supprime l'image
        }

        if (interface->gui[n].free & FREE_VALEUR)// Si on doit supprimer le texte
        {
            free(interface->gui[n].valeur);  // On libre le texte
        }

	if (interface->gui[n].info != NULL)// Temporaire :  rendre propre
        {
            free(interface->gui[n].info);  // On libre le texte de description
        }
    }

    free(interface->gui); // On supprime enfin les pointeurs vers ces elements

    // la variable interface sera libr  la fin du main automatiquement
}

void liberer_affichage(SDL_Surface* fenetre)
{
    SDL_FreeSurface(fenetre);// On supprime la surface de la fenetre

    TTF_Quit(); // On quitte SDL_ttf
    SDL_Quit(); // On quitte la SDL
}
// Affiche l'interface
void afficher_interface(t_interface* interface,t_reseau *res)
{
    long n,i,j; // Compteur
    SDL_Rect position, crop; // Structures utilises pour le positionnement et le rognage
    SDL_Color couleur; //Contient la couleur du texte  afficher
    SDL_Surface * tmpsurface = NULL; // Surface temporaire
    char str[256]; // Chaine de caractre pour les champ de saisie


    for (n=0;n<interface->gui_taille;n++)
    {
        TTF_Font *font=interface->font; // On prend la police de caractre normale
        str[0]=0; // On efface la chaine de caractre

        if (interface->gui[n].style & STYLE_ORANGE)
        {
            // On paramtre la couleur du texte  ORANGE
            couleur.r=255;
            couleur.g=128;
            couleur.b=0;
        }
        else if (interface->gui[n].style & STYLE_NOIR)
        {
            // On paramtre la couleur du texte  NOIR
            couleur.r=0;
            couleur.g=0;
            couleur.b=0;
        }
        else
        {
            // On paramtre la couleur du texte  BLANC
            couleur.r=255;
            couleur.g=255;
            couleur.b=255;
        }

        actualiser_gui(n, interface, res);// On actualise l'element courant en fonction de son flag, ainsi que les donnes qu'il concerne

        if (interface->gui[n].visible) // Si l'element est visible, on l'affiche
        {
            if (interface->gui[n].type == TEXTE) // Si l'element est de type Texte
            {
                if (interface->gui[n].style & STYLE_GROS)
                {
                    font=interface->font_gros; // On place le texte dans la surface temporaire
                }
                position=interface->gui[n].position;

                i=0;
                j=0;
                while(interface->gui[n].valeur[i]!=0)
                {
                    str[j]=interface->gui[n].valeur[i];

                    if(interface->gui[n].valeur[i+1]==0 || interface->gui[n].valeur[i]=='\n')
                    {
                        if(str[j]=='\n'){str[j]=0;}
                        else{str[j+1]=0;}

                        if (strlen(str))
                        {
                            tmpsurface = TTF_RenderText_Blended(font, str, couleur); // On place le texte dans la surface temporaire

                            if (interface->gui[n].style & STYLE_CENTRE)
                            {
                                position.x=interface->gui[n].position.x-tmpsurface->w/2;
                            }

                            SDL_BlitSurface(tmpsurface, 0, interface->fenetre, &position); // On blitte le texte
                            SDL_FreeSurface(tmpsurface); // On dtruit la surface temporaire pour une utilisation ultrieure
                        }
                            if (interface->gui[n].style & STYLE_GROS)
                            {
                                position.y+=32;
                            }
                            else
                            {
                                position.y+=24;
                            }

                            j=-1;

                    }

                    i++;
                    j++;
                }

                /*
                Remarque: On pourrait utiliser le champ image pour la surface au lieu de tmpsurface, mais on pourrait imaginer ke le texte
                aurait un arrire plan color
                */
            }
            else if (interface->gui[n].type == SAISIE)  // Si l'element est de type Saisie
            {
                couleur.r=0;
                couleur.g=0;
                couleur.b=0;

                sprintf(str,"%s ",interface->gui[n].valeur); // On place dans la chaine de caractre temporaire la valeur du champ

                if (interface->gui[n].etat == ACTIF) // Si l'element est actif (selectionn)
                {
                    if((SDL_GetTicks()/500)%2) // Toutes les demi-secondes
                    {
                            sprintf(str,"%s_",interface->gui[n].valeur); // On remplace la chaine de caractre pour y rajouter un curseur
                    }
                }

                tmpsurface = TTF_RenderText_Blended(font, str , couleur);// On place le texte dans la surface temporaire


                position.x = interface->gui[n].position.x + 2; // On laisse un marge de 2px  gauche
                position.y = interface->gui[n].position.y + ((interface->gui[n].crop.h - tmpsurface->h)/2); // On centre verticalement le texte dans le champ
                crop=interface->gui[n].crop; // on rogne le texte  la taille du champ pour eviter qu'il dpasse

                if ((tmpsurface->w+2) > interface->gui[n].crop.w) // Si le texte est plus large que le champ
                {
                    crop.x=tmpsurface->w-interface->gui[n].crop.w+2; // On l'aligne sur la droite et non sur la gauche avec une marge de 2 px
                }


                SDL_BlitSurface(interface->gui[n].image, &interface->gui[n].crop, interface->fenetre, &interface->gui[n].position); // On affiche le fond du champ
                SDL_BlitSurface(tmpsurface, &crop , interface->fenetre, &position);// Puis le texte (rogn) par dessus
                SDL_FreeSurface(tmpsurface); // On n'noublie pas de librer la mmoire de la surface temporaire
            }
            else if (interface->gui[n].type == BOUTON || interface->gui[n].type == SWITCH) // Si l'element est un bouton (switchable ou non)
            {
                if (interface->gui[n].valeur) // si le bouton contient un texte
                {
                    if (!interface->gui[n].image)
                    {
                        if (interface->gui[n].etat==SURVOL)
                        {
                            if (interface->gui[n].style & STYLE_ORANGE)
                            {
                                couleur.r=255;
                                couleur.g=255;
                                couleur.b=255;
                            }
                            else
                            {
                                couleur.r=255;
                                couleur.g=128;
                                couleur.b=0;
                            }
                        }
                    }

                    if (interface->gui[n].style & STYLE_GROS)
                    {
                        font=interface->font_gros; // On place le texte dans la surface temporaire
                    }

                    tmpsurface = TTF_RenderText_Blended(font, interface->gui[n].valeur, couleur); // On place le texte dans la surface temporaire

                    if (interface->gui[n].type == SWITCH) // Si l'element est un switch
                    {
                        // Alignement sur la gauche
                        position.x = interface->gui[n].position.x + 16; // On garde une marge  gauche de 16px
                        position.y = interface->gui[n].position.y + ((interface->gui[n].crop.h - tmpsurface->h)/2); // On centre verticalement le texte dans le champ
                    }
                    else // Sinon
                    {
                        // Alignement centr
                        position.x = interface->gui[n].position.x + ((interface->gui[n].crop.w - tmpsurface->w)/2);// On centre horizontalement le texte dans le champ
                        position.y = interface->gui[n].position.y + ((interface->gui[n].crop.h - tmpsurface->h)/2);// On centre verticalement le texte dans le champ
                    }
                }

                if (interface->gui[n].image)
                {
                    if (interface->gui[n].etat == ACTIF) // Si le bouton est actif (enfonc)
                    {
                        interface->gui[n].crop.y=2*interface->gui[n].crop.h; // On prend la 3eme position dans l'image (Enfonce)
                        // On dplace le texte en diagonale (effet d'enfoncement)
                        //position.x+=2; // 2 pixels vers la droite
                        position.y+=2; // 2 pixels vers le bas
                    }
                    else if (interface->gui[n].etat == SURVOL) // Sinon si il est juste survol
                    {
                        interface->gui[n].crop.y=interface->gui[n].crop.h; // On prend la 2eme position dans l'image (Highlighted - Eclaire)
                    }
                    else // Sinon
                    {
                        interface->gui[n].crop.y=0; // On prend la 1ere position dans l'image (Normale)
                    }

                    SDL_BlitSurface(interface->gui[n].image, &interface->gui[n].crop, interface->fenetre, &interface->gui[n].position); // On affiche le bouton
                }

                if (interface->gui[n].valeur) // Toujours si ya un texte
                {
                    SDL_BlitSurface(tmpsurface, 0, interface->fenetre, &position); // On affiche le texte par dessus
                    SDL_FreeSurface(tmpsurface); // On n'noublie pas de librer la mmoire de la surface temporaire
                }
            }
            else if (interface->gui[n].type == IMAGE) // SI l'element est juste une image
            {
                if (interface->gui[n].crop.h && interface->gui[n].crop.w) // Si l'on doit la rogner
                {
                    SDL_BlitSurface(interface->gui[n].image, &interface->gui[n].crop, interface->fenetre, &interface->gui[n].position); // On l'affiche rogne
                }
                else // Sinon
                {
                    SDL_BlitSurface(interface->gui[n].image, NULL, interface->fenetre, &interface->gui[n].position); // On l'affiche entire
                }
            }
        }
    }
}

// Actualise les elements et les donnes avant affichage
void actualiser_gui(long element,t_interface* interface,t_reseau *res)
{
    unsigned int temp;
    /*
    Remarque: Le switch est ger diffrement que le reste des elements dans la boucle d'evenements, car c'est un bouton ON/OFF,
    il peut tre actif meme si un autre element est selectionn, un clic inverse donc l'activation de ce type d'element
    */
    if (interface->gui[element].type!=SWITCH)// Si l'element n'est donc pas un switch
    {
        if (&(interface->gui[element]) == interface->gui_actif) // Si l'element est selectionn
        {
            interface->gui[element].etat=ACTIF; // Alors il est actif
        }
        else if (interface->pointeur.x>=interface->gui[element].position.x
        && interface->pointeur.x <  interface->gui[element].position.x+interface->gui[element].crop.w
        && interface->pointeur.y >= interface->gui[element].position.y
        && interface->pointeur.y <  interface->gui[element].position.y+interface->gui[element].crop.h
        ) // Si le pointeur est situ entre son coin haut gauche et son coin bas droit
        {
            interface->gui[element].etat=SURVOL; // Alors il est survol
        }
        else // Sinon
        {
            interface->gui[element].etat=INACTIF; // Il est inactif
        }
    }
    else // Sinon, si l'element est un switch
    {
        if (interface->gui[element].etat!=ACTIF) // ET qu'il n'est pas actif, cd, sur la position OFF
        {
            if (interface->pointeur.x>=interface->gui[element].position.x
            && interface->pointeur.x < interface->gui[element].position.x+interface->gui[element].crop.w
            && interface->pointeur.y>=interface->gui[element].position.y
            && interface->pointeur.y < interface->gui[element].position.y+interface->gui[element].crop.h
            ) // Si le pointeur est situ entre son coin haut gauche et son coin bas droit
            {
                interface->gui[element].etat=SURVOL; // Alors il est survol
            }
            else
            {
                interface->gui[element].etat=INACTIF; // Sinon, il est juste en position OFF
            }
        }
    }

    if (interface->gui[element].visible)
    {
        temp=obtenir_element(interface,MESSAGE);
        if (interface->gui[element].etat==SURVOL || (interface->gui[element].etat==ACTIF && interface->gui[temp].visible<2))
        {
            if (interface->gui[element].info)
            {
                if (interface->gui[temp].visible<3)
                {
                    sprintf(interface->gui[temp].valeur,"%s",interface->gui[element].info);
                    interface->gui[temp].style&=~STYLE_ORANGE;
                    interface->gui[temp].visible=2;
                }
            }
        }
    }
    /* Remarque:
    Le flag determine comment reagit un element, les donnes qu'il doit actualiser, ce qu'il stocke, et quel aspect
    il doit avoir en fonction des donnes qui lui sont exterieurs
    */
    switch(interface->gui[element].flag) // On actualise diffrement un element en fonction de son flag
    {
        case RESEAU:
            if (interface->gui[obtenir_element(interface,QUITTER)].visible)
            {
                interface->gui[element].visible=interface->charge;
            }
            break;
        case MESSAGE:
            if (interface->gui[element].visible>0)
            {
                interface->gui[element].visible--;
            }
            break;
        case SWITCH_FORME:
            if (interface->gui[element].etat==ACTIF && interface->gui[element].visible) // Si le switch est activ - Position ON
            {
                // Alors on rend visible les 3 elements du menu droulant
                afficher_groupe(interface,DEROUL_FORME,1,0);
            }
            else // Sinon en position OFF
            {
                // On masque les 3 elements du menu droulant
                afficher_groupe(interface,DEROUL_FORME,0,0);
            }

            if (interface->gui[element].visible)
            {
                if (strcmp(interface->gui[element].valeur,"Spirale")==0)
                {
                    afficher_groupe(interface,CONFIG_PERSO  ,0,0);
                    afficher_groupe(interface,CONFIG_SPIRALE,1,0);
                }
                else
                {
                    afficher_groupe(interface,CONFIG_PERSO  ,1,0);
                    afficher_groupe(interface,CONFIG_SPIRALE,0,0);
                }
            }
            break;
        case SWITCH_DESSIN:
            if (interface->gui[element].etat==ACTIF && interface->gui[element].visible) // Si le switch est activ - Position ON
            {
                // Alors on rend visible les 3 elements du menu droulant
                afficher_groupe(interface,DEROUL_DESSIN,1,0);
            }
            else // Sinon en position OFF
            {
                // On masque les 3 elements du menu droulant
                afficher_groupe(interface,DEROUL_DESSIN,0,0);
            }
            break;
        case FORME_PERSO:
        case FORME_SPIRALE:
            temp=obtenir_element(interface,SWITCH_FORME);
            if(strcmp(interface->gui[element].valeur,interface->gui[temp].valeur)==0 && interface->gui[element].etat==INACTIF)
            {interface->gui[element].etat=ACTIF;} // Alors on le rend actif pour le mettre en valeur
            break;
        case FORME_A:
        case FORME_B:
            temp=obtenir_element(interface,SWITCH_DESSIN);
            if(strcmp(interface->gui[element].valeur,interface->gui[temp].valeur)==0 && interface->gui[element].etat==INACTIF)
            {interface->gui[element].etat=ACTIF;} // Alors on le rend actif pour le mettre en valeur
            break;
        case EPSILON:
            if (interface->charge)
            {
                if(interface->gui[element].etat==ACTIF)
                {
                    sscanf(interface->gui[element].valeur,"%lf",&res->epsilon);
                }
                else
                {
                    sprintf(interface->gui[element].valeur,"%lf",res->epsilon); // On paramtre la premiere couleur
                }
            }
            break;
        case SEUIL:
            if (interface->charge)
            {
                if(interface->gui[element].etat==ACTIF)
                {
                    sscanf(interface->gui[element].valeur,"%lf",&res->seuil);
                }
                else
                {
                    sprintf(interface->gui[element].valeur,"%lf",res->seuil); // On paramtre la premiere couleur
                }
            }
            break;
        case COULEUR_A:
            if (interface->charge)
            {
                if(interface->gui[element].etat==ACTIF)
                {
                    if (sscanf(interface->gui[element].valeur,"%x",&temp)>0)
                    {
                        res->forme[0].r = (temp/(256*256))%256;
                        res->forme[0].g = (temp/256)%256;
                        res->forme[0].b = temp%256;
                    }
                }
                else
                {
                    sprintf(interface->gui[element].valeur,"%06X",(res->forme[0].r*256*256+res->forme[0].g*256+res->forme[0].b)); // On paramtre la premiere couleur
                }
            }
            break;
        case COULEUR_B:
            if (interface->charge)
            {
                if(interface->gui[element].etat==ACTIF)
                {
                    if (sscanf(interface->gui[element].valeur,"%x",&temp)>0)
                    {
                        res->forme[1].r = (temp/(256*256))%256;
                        res->forme[1].g = (temp/256)%256;
                        res->forme[1].b = temp%256;
                    }
                }
                else
                {
                    sprintf(interface->gui[element].valeur,"%06X",(res->forme[1].r*256*256+res->forme[1].g*256+res->forme[1].b)); // On paramtre la premiere couleur
                }
            }
            break;
        case CADRE_DESSIN:
            if(interface->gui[element].visible==1)
            {
                afficher_dessin(interface);
            }
            break;
        default: // Si l'element a un flag qui ne requiert aucune actualisation spcifique
        // On ne fait rien (et on vite un avertissement du compilateur)
            break;
    }
}

 // Effectuer l'action d'un flag
void effectuer_gui(enum gui_flag flag,t_interface* interface,t_reseau *res)
{
    long element;
    /* Remarque :
    Lorsqu'un lement est "valid", par la touche entre si c'est une saisie, ou un clic pour un bouton,
    alors on doit faire l'action correpondnate, et dsigne par le flag de l'element
    */
    switch(flag)// En fonction du flag
    {
        case FORME_SPIRALE:
            element=obtenir_element(interface,SWITCH_FORME);
            strcpy(interface->gui[element].valeur,"Spirale");
            interface->gui[element].etat=INACTIF;
            break;
        case FORME_PERSO:
            element=obtenir_element(interface,SWITCH_FORME);
            strcpy(interface->gui[element].valeur,"Personnalise");
            interface->gui[element].etat=INACTIF;
            break;
        case FORME_A:
            element=obtenir_element(interface,SWITCH_DESSIN);
            strcpy(interface->gui[element].valeur,"Forme A");
            interface->gui[element].etat=INACTIF;
            break;
        case FORME_B:
            element=obtenir_element(interface,SWITCH_DESSIN);
            strcpy(interface->gui[element].valeur,"Forme B");
            interface->gui[element].etat=INACTIF;
            break;
        case AIDE:
            afficher_groupe(interface,PRESENTATION,1,1);
            break;
        case CREER:
            afficher_groupe(interface,MENU_CREER,1,1);
            break;
        case RESEAU:
            afficher_groupe(interface,MENU_RESEAU,1,1);
            break;
        case NOUVEAU_NOM:
            effectuer_gui(CHARGER,interface,res);
            break;
        case CHARGER:
            if (charger(interface,res,interface->gui[obtenir_element(interface,NOUVEAU_NOM)].valeur))
            {
                afficher_message(interface,"Rseau Charg avec succs",0);
                SDL_BlitSurface(interface->texture[7], NULL, interface->gui[obtenir_element(interface, CADRE_RESULTAT)].image, NULL);
            }
            else
            {
                afficher_message(interface,"Impossible de Charger le Rseau",1);
            }

            break;
        case DESSINER:
            afficher_groupe(interface,MENU_DESSIN,1,1);
            break;
        case ANNULER:
            supprimer_point(interface);
            break;
        case EFFACER:
            effacer_dessin(interface);
            break;
        case NOUVEAU_APPRENDRE:
            switch (configurer_apprentissage(interface,res))
            {
                case 0: // Pas d'Erreur
                    interface->charge=1;

                    effectuer_gui(APPRENDRE,interface,res);

                    break;
                case 1:// ERREUR 1: Aucune couche entre
                    afficher_message(interface,"Vous n'avez pas entr la Configuration des Couches du Rseau",1);
                    break;
                case 2:// ERREUR 2: Erreur d'interpretation
                    afficher_message(interface,"L'interpretation des Couches a choue, veuillez corriger la Configuration",1);
                    break;
                case 3:// ERREUR 3: Forme Inconnue
                    afficher_message(interface,"Forme Selectionne inconnue",1);
                    break;
                case 4:// ERREUR 4: Epsilon erron
                    afficher_message(interface,"Facteur d'Apprentissage Epsilon non reconnu",1);
                    break;
                case 5:// ERREUR 5: Seuil erron
                    afficher_message(interface,"Seuil d'Apprentissage non reconnu",1);
                    break;
                case 6:// ERREUR 6: Epsilon erron
                    afficher_message(interface,"Nombre de Points de la Spirale non reconnu",1);
                    break;
                case 7:// ERREUR 7: Seuil erron
                    afficher_message(interface,"Offset de la Spirale non reconnu",1);
                    break;
                case 8:// ERREUR 8: Phase errone
                    afficher_message(interface,"Phase de gnration de la Spirale non reconnu",1);
                    break;
                case 9:// ERREUR 9: Problme generation Spirale
                    afficher_message(interface,"Impossible de gnrer la Forme demande",1);
                    break;
                case 10:// ERREUR 9: Problme generation Spirale
                    afficher_message(interface,"La Couleur A entre est incorrecte, elle n'est pas dans le bon format",1);
                    break;
                case 11:// ERREUR 9: Problme generation Spirale
                    afficher_message(interface,"La Couleur B entre est incorrecte, elle n'est pas dans le bon format",1);
                    break;
                default:
                    // Erreur Inconnue
                    afficher_message(interface,"Erreur Inconnu... Pas de Bol",1);
                    break;
            }
            break;
        case APPRENDRE:
            if (interface->charge)
            {
                // Affichage d'une fentre "vide"
                afficher_groupe(interface, MENU, 0, 1); // On efface le menu
                afficher_resultat(*res, interface->gui[obtenir_element(interface, CADRE_RESULTAT)].image, interface->options.apercu_resolution);
                interface->gui[obtenir_element(interface,CADRE_RESULTAT)].visible=1; // On affiche le trac
                afficher_message(interface, "[ESC] = Arrter l'apprentissage  ce stade.", 0); // Pour les impatients
                afficher_interface(interface,res);
                SDL_Flip(interface->fenetre); // On actualise l'cran


                if(apprentissage(*res, interface)) // On lance effectivement l'apprentissage
                {
                    afficher_message(interface, "L'apprentissage est termin. Calcul du Rsultat...", 0);
                }
                else{afficher_message(interface, "L'apprentissage a t interrompu. Calcul du Rsultat...", 1);}

                // Raffichage de l'interface

                afficher_interface(interface,res);
                SDL_Flip(interface->fenetre); // On actualise l'cran

                afficher_resultat(*res, interface->gui[obtenir_element(interface, CADRE_RESULTAT)].image, 1); // Affichage du rsultat avec la qualit maximale (facteur = 1)
                afficher_statistiques(res,interface->gui[obtenir_element(interface, STATISTIQUES)].valeur);
                afficher_groupe(interface, MENU, 1, 0); // On raffiche le menu
                afficher_groupe(interface, MENU_RESEAU, 1, 1); // On raffiche le menu
                afficher_message(interface, "Rsultat de l'Apprentissage", 0);
            }
            break;
        case TRACER:
            if (interface->charge)
            {
                afficher_message(interface,"Traage du Rsultat...",0);
                afficher_interface(interface,res);
                SDL_Flip(interface->fenetre); // On actualise l'cran

                afficher_resultat(*res, interface->gui[obtenir_element(interface, CADRE_RESULTAT)].image, 1); // Affichage du rsultat avec la qualit maximale (facteur = 1)
                afficher_message(interface,"Rsultat du Dernier Apprentissage",0);
            }
            break;
        case SAUVEGARDER:
            if (interface->charge)
            {
                if(strlen(interface->gui[obtenir_element(interface,NOM)].valeur)>0)
                {
                    if (sauvegarder_reseau(*res,interface->gui[obtenir_element(interface,NOM)].valeur))
                    {
                        afficher_message(interface,"Rseau Sauvegard avec succs",0);
                    }
                    else
                    {
                        afficher_message(interface,"Impossible de Sauvegarder le Rseau",1);
                    }
                }
                else
                {
                    afficher_message(interface,"Veuillez entrer un nom de rseau",1);
                }
            }
            break;
        case DETRUIRE:
            if (interface->charge)
            {
                supprimer_reseau(*res);
                interface->charge=0;
                afficher_groupe(interface, MENU_CREER, 1, 1); // On raffiche le menu
                afficher_message(interface,"Rseau dtruit",0);
            }
            break;
        case QUITTER:
            interface->continuer=0;
            break;
        default:
            break;
    }
    interface->gui_actif=0; // On dsactive ensuite l'element valid (ou l'element actuellement activ)
}

long obtenir_element(t_interface *interface,enum gui_flag flag)
{
    long n,element=-1;

    for (n=0; n<interface->gui_taille;n++)
    {
        if (interface->gui[n].flag==flag)
        {
            element=n;
        }
    }
    return element;
}

// Affiche le groupe d'elements prcis, et masque les autres
void afficher_groupe(t_interface *interface, enum gui_groupe groupe, long visible, long masquer)
{
    long n;

    for (n=0; n<interface->gui_taille;n++)
    {
        if (interface->gui[n].groupe==groupe)
        {
            interface->gui[n].visible=visible;
        }
        else if (interface->gui[n].groupe!=0 && interface->gui[n].groupe!=MENU && masquer)
        {
            interface->gui[n].visible=0;
        }
    }
}

void afficher_message(t_interface *interface, char *txt, long error)
{
    long message_element;

    message_element=obtenir_element(interface,MESSAGE);


    if (message_element!=-1)
    {
        sprintf(interface->gui[message_element].valeur,"%s",txt);

        if (error)
        {
            interface->gui[message_element].style|=STYLE_ORANGE;
        }
        else
        {
            interface->gui[message_element].style&=~STYLE_ORANGE;
        }

        interface->gui[message_element].visible=150;
    }
    else
    {
        printf("Erreur lors de l'obtention d'un element du GUI\n");
    }
}

long obtenir_fps(long incrementer)
{
    static long dernier_f=0,frames=0,dernier_temps=0;

    if (dernier_temps-SDL_GetTicks()>= 1000)
    {
        dernier_f=frames;
        frames=0;
        dernier_temps+=1000;
    }

    frames+=incrementer;

    return dernier_f;
}

void charger_config(t_interface *interface)
{
    FILE* fichier=NULL; // Pointeur sur le fichier .map  charger
    long n;
    char c;
    char str[SAISIE_MAX + 1];
    str[0]=0;

    interface->options.apercu_resolution=8;
    interface->options.apprentissage_ms=APPRENTISSAGE_MS;
    interface->options.pts_boucle=NBR_PTS_BOUCLE;
    interface->options.interval_poids=LONGUEUR_INTERVALE;

    fichier=fopen("meningix.conf","rb"); // On ouvre le fichier en LECTURE BINAIRE SEULE

    if (fichier) // Si un fichier a pu tre ouvert alors On charge ^^
    {
        while (!feof(fichier))
        {
            n=0;// On initialise le compteur d'indice
            str[0]=0;
            // Boucle Do...While pour capturer le nom du fichier
            do
            {
                c=fgetc(fichier); // On rcupre le caractre

                if (feof(fichier))
                {
                    c=';';
                }

                if (c!='\n' && c!='\r' && c!=';')
                {
                    if (n<=SAISIE_MAX)
                    {
                        str[n]=c; // Et on le rajoute au nom du fichier
                    }
                    n++; // ON n'oublie pas d'incrmenter l'indice
                }

            }while(c!=';'); // Le caractre EOT permet de dfinir la fin de la dclaration

            str[n]=0;

            if(comparer_commande("apprentissage_ms=", str)) //Si on demande de changer le port
            {
                sscanf(str, "apprentissage_ms=%ld", &interface->options.apprentissage_ms);
            }
            else if(comparer_commande("dessin_ms=", str)) //Si on demande de changer le port
            {
                sscanf(str, "dessin_ms=%ld", &interface->options.dessin_ms);
            }
            else if(comparer_commande("pts_boucle=", str)) //Si on demande de changer le port
            {
                sscanf(str, "pts_boucle=%ld", &interface->options.pts_boucle);
            }
            else if(comparer_commande("interval_poids=", str)) //Si on demande de changer le port
            {
                sscanf(str, "interval_poids=%lf", &interface->options.interval_poids);
            }
            else if(comparer_commande("apercu_resolution=", str)) //Si on demande de changer le port
            {
                sscanf(str, "apercu_resolution=%ld", &interface->options.apercu_resolution);
            }
        }

        fclose(fichier);
    }
}

long comparer_commande(char *cmd, char *str)
{
    long i, t; //Compteur pour la boucle

    t = strlen(cmd);
    if(t > strlen(str)) {return 0;} //Si la commande est plus longue que la saisie alors ce n'est pas cette commande qui est appele
    else
    {
        for(i = 0; i < t; i++) //Pour chaque caractre de la commande
        {
            if(cmd[i] != str[i]) {return 0;} //S'il diffre de la saisie alors ce n'est pas cette commande qui est appele
            else i++;
        }
        return 1; //Si tous les caractres sont identiques, on a trouv la commande appele
    }
}

long configurer_apprentissage(t_interface *aff,t_reseau *res)
{
    long erreur;

    /// Allocation des Donnes
    char *couches; // Contient la chaine de caractre des couches
    t_mode mode=SPIRALES;
    long points=0;
    long offset=0;
    double epsilon=0.0;
    double seuil=0.0;
    double phase=0.0;
    t_coord coord=CART;
    unsigned int couleur_a, couleur_b;

    /// Vrification des donness
    couches=aff->gui[obtenir_element(aff,COUCHES)].valeur;

    if (strlen(couches)==0)
    {
        return 1;
    }

    if (strcmp(aff->gui[obtenir_element(aff,SWITCH_FORME)].valeur,"Personnalise")==0)
    {
        mode=PERSO;
    }
    else if(strcmp(aff->gui[obtenir_element(aff,SWITCH_FORME)].valeur,"Spirale")==0)
    {
        mode=SPIRALES;
    }
    else
    {
        return 3;
    }

    erreur=sscanf(aff->gui[obtenir_element(aff,NOUVEAU_EPSILON)].valeur,"%lf",&epsilon);
    if(!erreur || erreur==EOF)
    {
        return 4;
    }

    erreur=sscanf(aff->gui[obtenir_element(aff,NOUVEAU_SEUIL)].valeur,"%lf",&seuil);
    if(!erreur || erreur==EOF)
    {
        return 5;
    }

    if(mode==SPIRALES)
    {
        erreur=sscanf(aff->gui[obtenir_element(aff,SPIRALE_POINTS)].valeur,"%ld",&points);
        if(!erreur || erreur==EOF)
        {
            return 6;
        }

        erreur=sscanf(aff->gui[obtenir_element(aff,SPIRALE_OFFSET)].valeur,"%ld",&offset);
        if(!erreur || erreur==EOF)
        {
            return 7;
        }

        erreur=sscanf(aff->gui[obtenir_element(aff,SPIRALE_PHASE)].valeur,"%lf",&phase);
        if(!erreur || erreur==EOF)
        {
            return 8;
        }
    }

    if( aff->gui[obtenir_element(aff,COORD)].etat == ACTIF)
    {
        coord=POL;
    }

    erreur=sscanf(aff->gui[obtenir_element(aff,NOUVEAU_COULEUR_A)].valeur,"%x",&couleur_a);
    if (!erreur || erreur==EOF)
    {
        return 10;
    }

    erreur=sscanf(aff->gui[obtenir_element(aff,NOUVEAU_COULEUR_B)].valeur,"%x",&couleur_b);
    if (!erreur || erreur==EOF)
    {
        return 11;
    }

    if (mode==PERSO)
    {
        if (aff->nbr_points<1)
        {
            return 12;
        }
    }
    /// Initialisation du rseau
    if (interpreter_couches(res,couches,aff->charge,aff->options.interval_poids))
    {
        return 2;
    }

    res->coord = coord;
    res->phase = phase;

    res->forme[0].r = couleur_a/(256*256)%256;
    res->forme[0].g = (couleur_a/256)%256;
    res->forme[0].b = couleur_a%256;

    res->forme[1].r = couleur_b/(256*256)%256;
    res->forme[1].g = (couleur_b/256)%256;
    res->forme[1].b = couleur_b%256;


    if (mode==SPIRALES)
    {
        if (!generer_spirales(res, points, offset, coord))
        {
            supprimer_reseau(*res);
            aff->charge=0;
            return 9;
        }
    }
    else
    {
        convertir_dessin(res,aff,coord);
    }



    res->epsilon = epsilon;
    res->seuil = seuil;

    return 0;
}

long interpreter_couches(t_reseau *res, char *str,long charge,double interval_poids)
{
    long nbr_couches, *nbr_neurones;
    long i, j, chiffre;

    i = 0;
    nbr_couches = 2;
    chiffre = 0;
    while(str[i] != 0)
    {
        if(str[i] >= '0' && str[i] <= '9') {chiffre = 1;}
        else if(str[i] == ' ')
        {
            nbr_couches += chiffre;
            chiffre = 0;
        }
        else {return 1;}
        i++;
    }
    nbr_couches += chiffre;

    nbr_neurones = (long *)malloc(nbr_couches * sizeof(long));
    if(!nbr_neurones) {return 0;}
    nbr_neurones[0] = 2; // Entres
    for(j = 1; j < nbr_couches - 1; j++) {nbr_neurones[j] = 0;} // Initialisation
    nbr_neurones[nbr_couches - 1] = 2; // Sorties

    i = 0;
    j = 1;
    chiffre = 0;
    while(str[i] != 0)
    {
        if(str[i] == ' ')
        {
            j += chiffre;
            chiffre = 0;
        }
        else // Chiffre
        {
            nbr_neurones[j] = nbr_neurones[j] * 10 + str[i] - '0';
            chiffre = 1;
        }
        i++;
    }

    if (charge)
    {
        supprimer_reseau(*res);
    }
    nouveau_reseau(res, nbr_couches, nbr_neurones,interval_poids);
    free(nbr_neurones);
    return 0;
}

long charger(t_interface *aff,t_reseau *res, char *nom_reseau)
{
    long i;

    /// Allocation des Donnes
    char couches[SAISIE_MAX]; // Contient la chaine de caractre des couches
    couches[0]=0;

    if (!charger_reseau(res,nom_reseau,aff->charge,aff->options.interval_poids))
    {
        return 0;
    }

    aff->charge=1; // Il est charg

    for(i=1;i<res->nbr_couches-1;i++)
    {
        sprintf(couches,"%s%ld ",couches,res->nbr_neurones[i]);
    }

// On Change l'interface avec les donnes rcupres

    //aff->gui[obtenir_element(aff,NOUVEAU_NOM)].valeur[0]=0; // On efface le nom entr
    sprintf(aff->gui[obtenir_element(aff,COUCHES)].valeur,couches); // On affiche les couches
    sprintf(aff->gui[obtenir_element(aff,NOUVEAU_EPSILON)].valeur,"%lf",res->epsilon); // On paramtre epsilon
    sprintf(aff->gui[obtenir_element(aff,NOUVEAU_SEUIL)].valeur,"%lf",res->seuil); // On paramtre epsilon
    if (res->coord==POL)
    {
        aff->gui[obtenir_element(aff,COORD)].etat=ACTIF;
    }
    else
    {
        aff->gui[obtenir_element(aff,COORD)].etat=INACTIF;
    }

    switch(res->mode)
    {
        case SPIRALES: // Si le rseau analyse des spirales
            sprintf(aff->gui[obtenir_element(aff,SWITCH_FORME)].valeur,"Spirale"); // On place le switch sur Spirale
            sprintf(aff->gui[obtenir_element(aff,SPIRALE_POINTS)].valeur,"%ld",res->nbr_pts); // On paramtre le nombre de points
            sprintf(aff->gui[obtenir_element(aff,SPIRALE_OFFSET)].valeur,"%ld",res->offset); // On paramtre l'offset
            sprintf(aff->gui[obtenir_element(aff,SPIRALE_PHASE)].valeur,"%lf",res->phase); // On paramtre la phase
            break;
        case PERSO: // Sinon, c'est un dessin
        default:
            sprintf(aff->gui[obtenir_element(aff,SWITCH_FORME)].valeur,"Personnalise"); // On place le switch sur Personnalise
        /// POINTS  COPIER !!!
            break;
    }

    aff->nbr_points=res->nbr_pts;
    aff->points=(t_point *)realloc(aff->points,aff->nbr_points*sizeof(t_point));

    for (i=0;i<res->nbr_pts;i++)
    {
      if(res->coord == CART)
      {
	aff->points[i].x=res->pts[i][0];
	aff->points[i].y=res->pts[i][1];
      }
      else if (res->coord == POL)
      {
	aff->points[i].x = (1.0 + res->pts[i][0] * cos(res->pts[i][1] * 2.0 * M_PI)) / 2.0;
	aff->points[i].y = (1.0 + res->pts[i][0] * sin(res->pts[i][1] * 2.0 * M_PI)) / 2.0;
      }

        if (res->att[i][0]==1.0)
        {
            aff->points[i].forme=0;
        }
        else
        {
            aff->points[i].forme=1;
        }
    }

    sprintf(aff->gui[obtenir_element(aff,NOM)].valeur,nom_reseau); // On paramtre le nom
    sprintf(aff->gui[obtenir_element(aff,NOUVEAU_COULEUR_A)].valeur,"%06X",(res->forme[0].r*256*256+res->forme[0].g*256+res->forme[0].b)); // On paramtre la premiere couleur
    sprintf(aff->gui[obtenir_element(aff,NOUVEAU_COULEUR_B)].valeur,"%06X",(res->forme[1].r*256*256+res->forme[1].g*256+res->forme[1].b)); // On paramtre la seconde couleur
    afficher_statistiques(res,aff->gui[obtenir_element(aff, STATISTIQUES)].valeur);
    return 1;
}

long ajouter_point(t_interface *interface)
{
    long element;
    static Uint32 dernier_temps=0; // Enregistre le dernier temps avant scroll (conserv pour un appel futur)

    if ((SDL_GetTicks() - dernier_temps) > interface->options.dessin_ms)
    {
        interface->nbr_points++;
        interface->points=(t_point *)realloc(interface->points,interface->nbr_points*sizeof(t_point));

        element=obtenir_element(interface,CADRE_DESSIN);

        interface->points[interface->nbr_points-1].x=(interface->pointeur.x-interface->gui[element].position.x)/(double)interface->gui[element].crop.w;
        interface->points[interface->nbr_points-1].y=1.0-((interface->pointeur.y-interface->gui[element].position.y)/(double)interface->gui[element].crop.h);

        element = obtenir_element(interface,SWITCH_DESSIN);

        if (strcmp(interface->gui[element].valeur,"Forme A")==0)
        {
            interface->points[interface->nbr_points-1].forme=0;
        }
        else if (strcmp(interface->gui[element].valeur,"Forme B")==0)
        {
            interface->points[interface->nbr_points-1].forme=1;
        }
        else
        {
            interface->points[interface->nbr_points-1].forme=0;
        }

        dernier_temps=SDL_GetTicks();
    }

    return 1;
}

void supprimer_point(t_interface *interface)
{
    if (interface->nbr_points)
    {
        interface->nbr_points--;
        interface->points=(t_point *)realloc(interface->points,interface->nbr_points*sizeof(t_point));
    }
    return ;
}

void effacer_dessin(t_interface *interface)
{
    interface->nbr_points=0;
    free(interface->points);
    interface->points=NULL;

    return ;
}

void afficher_dessin(t_interface *interface)
{
    unsigned int i;
    long cadre;
    SDL_Rect point;
    SDL_Color couleur_a,couleur_b,couleur;

    cadre=obtenir_element(interface,CADRE_DESSIN);

    point.h=8;
    point.w=8;

    if (sscanf(interface->gui[obtenir_element(interface,NOUVEAU_COULEUR_A)].valeur,"%x",&i)>0)
    {
        couleur_a.r = (i/(256*256))%256;
        couleur_a.g = (i/256)%256;
        couleur_a.b = i%256;
    }

    if (sscanf(interface->gui[obtenir_element(interface,NOUVEAU_COULEUR_B)].valeur,"%x",&i)>0)
    {
        couleur_b.r = (i/(256*256))%256;
        couleur_b.g = (i/256)%256;
        couleur_b.b = i%256;
    }

    SDL_FillRect(interface->gui[cadre].image, 0, SDL_MapRGB(interface->gui[cadre].image->format, 0,0,0)); // Affichage

    // Affichage des points exemple
    for(i = 0; i < interface->nbr_points; i++)
    {
        point.h=8;
        point.w=8;
        point.x = (interface->gui[cadre].image->w * interface->points[i].x) - 4;
        point.y = (interface->gui[cadre].image->h * (1.0 - interface->points[i].y)) - 4;

        switch(interface->points[i].forme)
        {
            case 0:
                couleur=couleur_a;
                break;
            case 1:
                couleur=couleur_b;
                break;
            default:
                couleur.r=255;
                couleur.g=255;
                couleur.b=255;
                break;
        }

        SDL_FillRect(interface->gui[cadre].image, &point, SDL_MapRGB(interface->gui[cadre].image->format, couleur.r, couleur.g, couleur.b)); // Affichage
    }

    return ;
}

long convertir_dessin(t_reseau *res,t_interface *interface,long coord)
{
    long i; // Compteur qui parcourt les points

    /// Initialisation de la description de l'ensemble d'exemple
    res->mode = PERSO; // On va dessiner les 2 spirales
    res->nbr_pts = interface->nbr_points; // Nombre de points dans l'ensemble d'exemple

    /// Allocation mmoire pour l'ensemble d'exemple
    res->pts = (double **)malloc(res->nbr_pts * sizeof(double *));
    if(!res->pts) {exit(EXIT_FAILURE);}
    res->att = (double **)malloc(res->nbr_pts * sizeof(double *));
    if(!res->att) {exit(EXIT_FAILURE);}
    for(i = 0; i < res->nbr_pts; i++) // Pour chaque point  apprendre
    {
        res->pts[i] = (double *)malloc(res->nbr_neurones[0] * sizeof(double)); // Il y a autant d'entres que de neurones d'entres
        if(!res->pts[i]) {exit(EXIT_FAILURE);}
        res->att[i] = (double *)malloc(res->nbr_neurones[res->nbr_couches - 1] * sizeof(double)); // Il y a autant de sorties que de neurones de sorties
        if(!res->att[i]) {exit(EXIT_FAILURE);}
    }

    /// Remplissage en coordonnes cartsienne (d'abord)
    for(i = 0; i < res->nbr_pts; i++) // Pour chaque point, on apprend alternativement un point de la premire ou de la deuxime spirale
    {
        if(coord == POL)
	{
	  res->pts[i][0] = interface->points[i].x - 0.5;
	  res->pts[i][1] = interface->points[i].y - 0.5;
	}
	else
	{
	  res->pts[i][0] = interface->points[i].x;
	  res->pts[i][1] = interface->points[i].y;
	}

        if(interface->points[i].forme)
        {
            res->att[i][0] = 0.0;
            res->att[i][1] = 1.0;
        }
        else
        {
            res->att[i][0] = 1.0;
            res->att[i][1] = 0.0;
        }
    }

    /// Conversion dans le systme de coordonnes dsir
    switch(coord) // En fonction du systme de coordonnes
    {
        case CART: // Il n'y a plus rien  faire
            break;
        case POL: // Conversion
            for(i = 0; i < res->nbr_pts; i++) {cart_pol(res->pts[i], res->pts[i]);} // On convertit chaque point
	      normalisation(res->pts, res->nbr_pts, 2, POL);
            break;
        default: // Systme de coordonne inconnue
            return 0;
            break;
    }

    return 1;
}

void afficher_statistiques(t_reseau *res,char* texte)
{
    long i, nbr_neurones=0;
    sprintf(texte,"> Configuration: \n");

    for(i=1;i<res->nbr_couches-1;i++)
    {
        nbr_neurones+=res->nbr_neurones[i];
        sprintf(texte,"%s%ld ",texte,res->nbr_neurones[i]);
    }

    sprintf(texte,"%s\nNombre de Neurones: %ld\n",texte,nbr_neurones);
    sprintf(texte,"%s\n> Forme\nType de Forme: ",texte);
    switch (res->mode)
    {
        case SPIRALES:
            sprintf(texte,"%sSpirales\n",texte);
            break;
        case PERSO:
            sprintf(texte,"%sPersonnalise\n",texte);
            break;
        default: break;
    }
    sprintf(texte,"%sNombre de Points: %ld\n",texte,res->nbr_pts);
    if (res->mode == SPIRALES)
    {
        sprintf(texte,"%sOffset: %ld\n",texte,res->offset);
        sprintf(texte,"%sPhase: %lf\n",texte,res->phase);
    }
    sprintf(texte,"%s\n> Apprentissage\n",texte);
    sprintf(texte,"%sEpsilon: %lf\n",texte,res->epsilon);
    sprintf(texte,"%sSeuil: %lf\n",texte,res->seuil);
    sprintf(texte,"%sTemps pass: %0.2lf s\n",texte,(*res->temps/1000.0));
}
