#ifndef COUCHE_H_INCLUDED
#define COUCHE_H_INCLUDED

#include <SDL/SDL.h>
#include "typedef.h"

#define LONGUEUR_INTERVALE  +1.0E+0     // Longueur de l'intervale d'initialisation des poids
#define NBR_PTS_BOUCLE      100         // Nombre d'exemples  apprendre lors d'une boucle d'apprentissage (puis test pour savoir si l'apprentissage est termin)
#define SPIRALES_PAS        0.2         // Pas entre les diffrentes valeurs de t (cf. sujet)
#define APPRENTISSAGE_MS    500         // Temps minimal entre chaque actualisation de l'apperue
#define NEU_DIR             "neu/"
#define NEU_EXT             ".mgx"

void cart_pol(double *cart, double *pol);                                                           // Conversion de coordonnes cartsiennes en coordonnes polaires
void normalisation(double **exemple, double nbr_exemples, double nbr_entrees, t_coord coord);       // Normalisation des entres
long nouveau_reseau(t_reseau *res, long nbr_couches, long *nbr_neurones, double interval_poids);    // Cre un nouveau rseau (allocation mmoire et initialisation des donnes ncessaires)
void supprimer_reseau(t_reseau res);                                                                // Effectue les librations de la mmoire utilise par le rseau
long generer_spirales(t_reseau *res, long nbr_pts, long offset, t_coord coord);                     // Gnre les points exemples pour les spirales
void supprimer_exemples(t_reseau res);                                                              // Supprimes les points exemples d'un rseau
long sauvegarder_reseau(t_reseau res, char *nom_reseau);                                            // Sauvegarde le rseau dans le fichier demand
long charger_reseau(t_reseau *res, char *nom_reseau, long charge, double interval_poids);           // Charge le rseau depuis le fichier demand
double calculer_reseau(t_reseau res, double *entree, double *sortie, double *attendue);             // Effectue le calcul de la sortie correspondant  l'entre du rseau, corrige les poids si une sortie est attendue (!= NULL) et renvoie la valeur absolue du facteur de correction la plus grande
long apprentissage(t_reseau res, t_interface *aff);                                                 // Effectue l'apprentissage complet
long afficher_resultat(t_reseau res, SDL_Surface *cadre, long facteur);                             // Affiche le rsultat pour une surface complte (le facteur est le nombre de pixels par point calcul)

#endif // COUCHE_H_INCLUDED
